/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Node;

public class VWOperationTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    public static final int COL_DESCRIPTION = 1;
    private Frame m_parentFrame = null;
    private VWQueueDefinition m_queueDefinition = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWOperationTableModel(Frame parentFrame, VWQueueDefinition vwQueueDef) {
        this.m_parentFrame = parentFrame;
        this.initialize(vwQueueDef);
    }

    public VWOperationDefinition getRowItemAt(int nRowIndex) {
        VWOperationDefinition operationDef = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            operationDef = (VWOperationDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return operationDef;
    }

    public void initialize(VWQueueDefinition vwQueueDef) {
        try {
            VWOperationDefinition[] operations;
            this.m_queueDefinition = vwQueueDef;
            this.m_rowData = new Vector();
            if (this.m_queueDefinition != null && (operations = this.m_queueDefinition.getOperations()) != null) {
                for (int nIndex = 0; nIndex < operations.length; ++nIndex) {
                    this.m_rowData.addElement(operations[nIndex]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void addItem(String operationDefinition) {
        try {
            if (operationDefinition == null) {
                return;
            }
            VWXMLWrapper operationWrapper = new VWXMLWrapper(operationDefinition);
            String name = VWXMLWrapper.getNodeValue(operationWrapper.getRootNode(), "name");
            VWOperationDefinition operationDef = this.m_queueDefinition.createOperation(this.legalizeName(name));
            this.m_rowData.addElement(operationDef);
            this.m_bIsModified = true;
            String description = VWXMLWrapper.getNodeValue(operationWrapper.getRootNode(), "description");
            if (description != null && description.length() > 0) {
                operationDef.setDescription(description);
            }
            VWAttributeInfo attributeInfo = operationDef.getAttributeInfo();
            operationWrapper.setNodeValue(operationWrapper.getRootNode(), "name", operationDef.getName());
            attributeInfo.setFieldValue("F_OperationDescriptor", operationWrapper.toString());
            operationDef.setAttributeInfo(attributeInfo);
            Node[] parameterNodes = VWXMLWrapper.getNodesNamed(operationWrapper.getRootNode(), "parameter");
            if (parameterNodes != null && parameterNodes.length > 0) {
                for (int i = 0; i < parameterNodes.length; ++i) {
                    try {
                        String paramName = VWXMLWrapper.getNodeValue(parameterNodes[i], "name");
                        int nMode = 1;
                        String temp = VWXMLWrapper.getNodeValue(parameterNodes[i], "mode");
                        if (temp != null && temp.length() > 0) {
                            nMode = Integer.parseInt(temp);
                        }
                        int nType = 1;
                        temp = VWXMLWrapper.getNodeValue(parameterNodes[i], "type");
                        if (temp != null && temp.length() > 0) {
                            nType = Integer.parseInt(temp);
                        }
                        boolean bIsArray = false;
                        temp = VWXMLWrapper.getNodeValue(parameterNodes[i], "isarray");
                        if (temp != null && temp.length() > 0 && temp.equalsIgnoreCase("true")) {
                            bIsArray = true;
                        }
                        VWParameterDefinition paramDef = operationDef.createParameter(paramName, nMode, nType, bIsArray);
                        description = VWXMLWrapper.getNodeValue(parameterNodes[i], "description");
                        if (description == null || description.length() <= 0) continue;
                        paramDef.setDescription(description);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
            }
            int nRowIndex = this.getRowCount() - 1;
            this.fireTableRowsInserted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWOperationDefinition operationDef = this.getRowItemAt(nRowIndex);
            this.m_queueDefinition.deleteOperation(operationDef.getName());
            this.m_rowData.removeElementAt(nRowIndex);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWOperationDefinition operationDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (operationDef != null) {
                        return operationDef.getName();
                    }
                    return "";
                }
                case 1: {
                    if (operationDef != null) {
                        return operationDef.getDescription();
                    }
                    return "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_queueDefinition = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            VWOperationDefinition operationDef = this.getRowItemAt(nRowIndex);
            if (operationDef != null && VWStringUtils.compare(newName, operationDef.getName()) != 0) {
                operationDef.setName(newName);
                this.m_bIsModified = true;
            }
            this.fireTableCellUpdated(nRowIndex, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWOperationDefinition operationDef = this.getRowItemAt(nRowIndex);
            if (operationDef != null) {
                operationDef.setDescription(aValue.toString());
                this.m_bIsModified = true;
            }
            this.fireTableCellUpdated(nRowIndex, 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String legalizeName(String name) {
        if (name.length() > 128) {
            name = name.substring(0, 127);
        }
        String legalName = name;
        for (int i = 0; i < 99; ++i) {
            try {
                if (VWFieldType.isValidName(legalName)) {
                    this.m_queueDefinition.getOperation(legalName);
                }
            }
            catch (Exception ex) {
                return legalName;
            }
            String index = Integer.toString(i + 1);
            legalName = name.length() + index.length() > 128 ? name.substring(0, name.length() - (index.length() + 1)) + index : name + index;
        }
        return null;
    }
}

